<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit;
}

$conn = mysqli_connect("localhost", "root", "", "dubai_treasury_bank");
if (!$conn) {
    die("DB error");
}

$users = mysqli_query($conn, "SELECT id, full_name, account_number, account_balance FROM users ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<link rel="stylesheet" href="assets/admin-dashboard-main.css">
</head>

<body>
<div class="app">

<div class="top-header">
    <div>
        <small>Admin Panel</small>
        <h4><?php echo $_SESSION['admin_name']; ?></h4>
    </div>
    <i class="bi bi-shield-lock"></i>
</div>

<div class="transaction-section">
    <div class="section-title">
        <h6>All Users</h6>
        <small>Manage accounts</small>
    </div>

    <?php while ($u = mysqli_fetch_assoc($users)) { ?>
        <div class="transaction-item">
            <i class="bi bi-person"></i>
            <div class="details">
                <strong><?php echo htmlspecialchars($u['full_name']); ?></strong>
                <small><?php echo $u['account_number']; ?></small>
            </div>
            <a href="admin_view_user.php?uid=<?php echo $u['id']; ?>" class="btn btn-sm btn-primary">
                View
            </a>
        </div>
    <?php } ?>

</div>
</div>
</body>
</html>
